//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##   //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##   //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####    //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##     //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####    //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##   //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##   //
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####         //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##        //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #              //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####         //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##        //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####         //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////

//Settings//
#include "/lib/settings.glsl"

//Varyings//
varying vec2 texCoord, lmCoord;
varying vec3 upVec, sunVec;

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Uniforms//
uniform float rainStrength;
uniform float rainStrengthS;
uniform float screenBrightness;
uniform float timeAngle, timeBrightness;
uniform float viewWidth, viewHeight;

uniform ivec2 eyeBrightnessSmooth;

uniform mat4 gbufferProjectionInverse;

uniform sampler2D texture;
uniform sampler2D depthtex0;

//Common Variables//
float eBS = eyeBrightnessSmooth.y / 255.0;
float sunVisibility  = clamp(dot( sunVec,upVec) + 0.0625, 0.0, 0.125) * 8.0;
float moonVisibility = clamp(dot( -sunVec,upVec) + 0.0625, 0.0, 0.125) * 8.0;
float screenBrightness2 = clamp(screenBrightness, 0.0, 1.0);

//Common Functions//
void Defog(inout vec3 albedo){
	float z = texture2D(depthtex0,gl_FragCoord.xy/vec2(viewWidth,viewHeight)).r;
	if (z == 1.0) return;
	
	vec4 screenPos = vec4(gl_FragCoord.xy / vec2(viewWidth, viewHeight), z, 1.0);
	vec4 viewPos = gbufferProjectionInverse * (screenPos * 2.0 - 1.0);
	viewPos /= viewPos.w;
	
	float fog = length(viewPos) * OVERWORLD_FOG_DENSITY / 256.0;
	float clearDay = sunVisibility * (1.0 - rainStrengthS);
	fog *= (0.5 * rainStrengthS + 1.0) / (3.0 * clearDay + 1.0);
	fog = 1.0 - exp(-2.0 * pow(fog, 0.25 * clearDay + 1.25) * eBS);
	albedo.rgb /= 1.0 - fog;
}

//Includes//
#include "/lib/color/lightColor.glsl"
#include "/lib/color/blocklightColor.glsl"

//Program//
void main(){
	#if defined NETHER || defined END
	discard;
	#endif
	
	vec4 albedo = vec4(0.0);
	
	#ifdef WEATHER
	albedo.a = texture2D(texture, texCoord).a;
	
	if (albedo.a > 0.001){
		albedo.rgb = texture2D(texture, texCoord).rgb;
		
		albedo.a *= 0.25 * rainStrengthS * length(albedo.rgb / 3.0) * float(albedo.a > 0.1);
		albedo.rgb = sqrt(albedo.rgb);
		albedo.rgb *= (ambientCol + lmCoord.x * lmCoord.x * blocklightCol) * WEATHER_OPACITY;
		
		#if defined FOG && MC_VERSION <= 11500
		if (gl_FragCoord.z > 0.991) Defog(albedo.rgb);
		#endif
	}
	#endif
	
	/* DRAWBUFFERS:0 */
	gl_FragData[0]=albedo;
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Uniforms//
uniform float timeAngle;

#ifdef NOUVELLE_PLUIE
uniform vec3 cameraPosition;
#endif

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform float frameTimeCounter;

//Program//
void main(){
	
	vec4 position=gbufferModelViewInverse*gl_ModelViewMatrix*gl_Vertex;
	float frameTimeCounter2=frameTimeCounter*2.0;
	
	#ifdef NOUVELLE_PLUIE
	
	vec3 worldpos=position.xyz+cameraPosition;
	bool istopv=worldpos.y>cameraPosition.y+5.;
	if(!istopv)position.xz+=vec2(2.3,1.0)+sin(frameTimeCounter2)*sin(frameTimeCounter2)*sin(frameTimeCounter2)*vec2(2.1,0.6);
	position.xz-=(vec2(2.8,1.)+sin(frameTimeCounter2)*sin(frameTimeCounter2)*sin(frameTimeCounter2)*vec2(2.1,0.6))*0.25;
	position.xz-=(vec2(3.5,1.)+sin(frameTimeCounter2)*sin(frameTimeCounter2)*sin(frameTimeCounter2)*vec2(2.1,0.6))*0.45;
	#endif
	
	texCoord=(gl_TextureMatrix[0]*gl_MultiTexCoord0).xy;
	
	lmCoord=(gl_TextureMatrix[1]*gl_MultiTexCoord1).xy;
	lmCoord=clamp(lmCoord*2.0-1.0,0.0,1.0);
	
	#ifdef MOUVEMENT_CAM
	position+=vec4(0.03*sin(frameTimeCounter*3.0*SPEED_MOOVE),0.015*cos(frameTimeCounter*4.0*SPEED_MOOVE),0.0,0.0)*gbufferModelView;
	#endif
	
	const vec2 sunRotationData=vec2(cos(sunPathRotation*0.01745329251994),-sin(sunPathRotation*.01745329251994));
	float ang=fract(timeAngle-0.25);
	ang=(ang+(cos(ang*3.14159265358979)*-0.5+0.5-ang)/3.0)*6.28318530717959;
	sunVec=normalize((gbufferModelView*vec4(vec3(-sin(ang),cos(ang)*sunRotationData)*2000.0,1.0)).xyz);
	
	upVec=normalize(gbufferModelView[1].xyz);
	
	gl_Position=gl_ProjectionMatrix*gbufferModelView*position;
	
}

#endif